﻿© Fluke Calibration. All Rights Reserved.                  MET/CAL Procedure
=============================================================================
INSTRUMENT:            Excel Example: Frequency Response Graphing Simulation
DATE:                  2011-12-14 17:36:33
AUTHOR:                Fluke Calibration
REVISION:              $Revision: $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       104
=============================================================================
#
# This procedure requires Microsoft Excel to be installed on the computer.
#
# For information on the Excel application COM object, refer to
# the following link:
#
# http://msdn.microsoft.com/en-us/library/microsoft.office.interop.excel.aspx
#
# This procedure demonstrates the LIB FSC capability to graph test results in
# in Excel, as the procedure is running.
#
# Required subprocedure(s):
#        Sub xlApp: Disable Prompts and Exit Excel
#
# Required file(s):
#        graph.xlsx (embedded in Project)
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  HEAD         FREQUENCY RESPONSE GRAPHING SIMULATION

# Store the path to the Excel file embedded into the Editor Project.
  1.002  MATH         xlFile = PXETEMP() & "graph.xlsx"

# Launch MS Excel and make it visible.
  1.003  LIB          COM xlApp = "Excel.Application";
  1.004  LIB          xlApp.Visible = True;

# Specify a clear operation for this procedure, which will automatically
# execute when the procedure terminates.
  1.005  CLEAR        -c Sub xlApp: Disable Prompts and Exit Excel

# Open workbook.
  1.006  LIB          COM xlWB = xlApp.Workbooks;
  1.007  LIB          xlWB.Open(xlFile);

# Select worksheet.
  1.008  LIB          COM xlWS = xlApp.Worksheets;
  1.009  LIB          xlWS.Select();

# Initialize loop variables.
  1.010  MATH         row = 2
  1.011  MATH         freq  = 100E+6; fstep = 100E+6
  1.012  MATH         power = -1.0;   pstep = 0.0625

# Simulate frequency response test data.
  1.013  WHILE        freq <= 3.2E+9

# Write simulated frequency.
  1.014  MATH         cell = "A" & row
  1.015  LIB          COM cell_freq = xlApp.Range[cell];
  1.016  LIB          cell_freq.Value2 = freq;

# Write simulated power.
  1.017  MATH         cell = "B" & row
  1.018  LIB          COM cell_power = xlApp.Range[cell];
  1.019  LIB          cell_power.Value2 = power;

# Change tolerance and uncertainty based on test frequency.
  1.020  IF           (freq >= 1E+9) && (freq <= 2E+9)
  1.021  MATH         tol = 1.50; unc = 0.5
  1.022  ELSE
  1.023  MATH         tol = 1.25; unc = 0.1
  1.024  ENDIF

# Write uncertainty.
  1.025  MATH         cell = "E" & row
  1.026  LIB          COM cell_unc = xlApp.Range[cell];
  1.027  LIB          cell_unc.Value2 = unc;

# Calculate upper and lower limits (UL and LL) from tolerance.
  1.028  MATH         UL = tol; LL = tol * (-1)

# Write lower tolerance limit.
  1.029  MATH         cell = "C" & row
  1.030  LIB          COM cell_LL = xlApp.Range[cell];
  1.031  LIB          cell_LL.Value2 = LL;

# Write upper tolerance limit.
  1.032  MATH         cell = "D" & row
  1.033  LIB          COM cell_UL = xlApp.Range[cell];
  1.034  LIB          cell_UL.Value2 = UL;

# Increment row, frequency, and power.
  1.035  MATH         row   = row + 1
  1.036  MATH         freq  = freq  + fstep
  1.037  MATH         power = power + pstep
  1.038  ENDW

  1.039  DISP         The Excel graph should now be populated with
  1.039  DISP         simulated data.

  1.040  HEAD
  1.041  END